<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
$page_title = "Order Submitted";
include __DIR__ . '/../includes/header.php';

$code = $_GET['code'] ?? '';
$stmt = $pdo->prepare("SELECT * FROM orders WHERE order_code = ?");
$stmt->execute([$code]);
$order = $stmt->fetch();
?>

<div class="container mt-5">
  <div class="row justify-content-center">
    <div class="col-md-6">

<?php if (!$order): ?>

      <div class="alert alert-danger text-center">
        Order not found.
      </div>

<?php else: ?>

      <div class="card shadow-lg border-0 rounded-4">
        <div class="card-body text-center p-4">

          <!-- Success Icon -->
          <div class="mb-3">
            <div class="bg-success text-white rounded-circle d-inline-flex justify-content-center align-items-center"
                 style="width:70px;height:70px;font-size:36px;">
              ✓
            </div>
          </div>

          <h3 class="fw-bold">Order Submitted!</h3>
          <p class="text-muted mb-2">Your Order ID</p>

          <h2 class="fw-bold text-primary mb-3">
            <?= htmlspecialchars($order['order_code']) ?>
          </h2>

          <p class="text-muted mb-1">Total Amount</p>
          <h4 class="fw-bold text-success mb-3">
            RM <?= number_format($order['total_amount'], 2) ?>
          </h4>

          <p class="text-muted">
            Order for date:
            <strong><?= date('d M Y', strtotime($order['order_for_date'])) ?></strong>
          </p>

          <?php if (!empty($order['morning_pickup_time'])): ?>
            <p class="text-muted">
              Morning pickup at
              <strong><?= date('g:i A', strtotime($order['morning_pickup_time'])) ?></strong>
            </p>
          <?php endif; ?>

          <p class="mb-4">
            A confirmation email has been sent.<br>
            Send this Order ID to the canteen admin.
          </p>

          <a href="index.php" class="btn btn-primary px-4">
            Back to Menu
          </a>

        </div>
      </div>

<?php endif; ?>

    </div>
  </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
