<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$page_title = "Canteen Order";
include __DIR__ . '/../includes/header.php';



if (empty($_SESSION['order_token'])) {
    $_SESSION['order_token'] = bin2hex(random_bytes(32));
}

$stmt = $pdo->query("
    SELECT active_order_date
    FROM order_settings
    WHERE id = 1
");

$orderDate = $stmt->fetchColumn();

if (!$orderDate) {
    die('Ordering date not set. Please contact admin.');
}


/* ---------- Fetch menu ---------- */
$stmt = $pdo->prepare("
    SELECT *
    FROM menu_items
    WHERE published = 1
    ORDER BY meal_session, id
");
$stmt->execute();
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ---------- Split menu ---------- */
$morningMenu = [];
$afternoonMenu = [];

foreach ($items as $it) {
    ($it['meal_session'] === 'morning')
        ? $morningMenu[] = $it
        : $afternoonMenu[] = $it;
}

$can_order = is_order_open();
?>

<style>

body {
    background:#f4f6f8;
    font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto;
}

h4,h5,h6 {
    font-weight:600;
    color:#1f2937;
}

/* Cards */
.card {
    border-radius:14px;
    border:1px solid #e5e7eb;
    box-shadow:0 4px 10px rgba(0,0,0,.04);
    transition:.2s ease;
}
.card:hover {
    transform:translateY(-2px);
}

/* Menu image */
.menu-img {
    height:160px;
    object-fit:cover;
    border-top-left-radius:14px;
    border-top-right-radius:14px;
}

/* Price */
.price-text {
    font-weight:700;
    color:#0f172a;
}

/* Qty buttons */
.qty-btn {
    width:36px;
    font-weight:700;
}

/* Summary */
.summary-card {
    height:calc(100vh - 120px);
    border-radius:16px;
}

.summary-body {
    display:flex;
    flex-direction:column;
    height:100%;
}

.summary-scroll {
    flex-grow:1;
    overflow-y:auto;
    border-top:1px solid #e5e7eb;
    border-bottom:1px solid #e5e7eb;
    padding:10px 0;
}

/* Buttons */
.btn-primary {
    background:#2563eb;
    border-color:#2563eb;
    font-weight:600;
    padding:.6rem;
}

.btn-primary:disabled {
    background:#94a3b8;
    border-color:#94a3b8;
}

.alert {
    border-radius:12px;
}

body { background:#f4f6f8; }
h4,h5,h6 { font-weight:600; color:#1f2937; }

.card { border-radius:10px; border:1px solid #e5e7eb; }

.menu-img {
    height:180px;
    object-fit:cover;
    border-bottom:1px solid #e5e7eb;
}

.price-text { font-weight:600; color:#111827; }
.qty-btn { width:36px; }

.summary-card { height:calc(100vh - 120px); }
.summary-body { display:flex; flex-direction:column; height:100%; }

.summary-scroll {
    flex-grow:1;
    overflow-y:auto;
    border-top:1px solid #e5e7eb;
    border-bottom:1px solid #e5e7eb;
    padding:8px 0;
}

.btn-primary {
    background:#2563eb;
    border-color:#2563eb;
    font-weight:600;
}
.menu-section {
    display:flex;
    align-items:center;
    gap:12px;
    margin-top:32px;
    margin-bottom:16px;
}

.menu-section span {
    font-size:0.85rem;
    font-weight:700;
    letter-spacing:1px;
    text-transform:uppercase;
    color:#2563eb;
    white-space:nowrap;
}

.menu-section::after {
    content:"";
    flex-grow:1;
    height:2px;
    background:#e5e7eb;
}

</style>

<?php if ($can_order): ?>
<form method="post" action="order_submit.php" id="orderForm">
<?php else: ?>
<form>
<?php endif; ?>
    <input type="hidden" name="order_token" value="<?= $_SESSION['order_token'] ?>">
<input type="hidden" name="order_for_date" value="<?= htmlspecialchars($orderDate) ?>">
<input type="hidden" name="morning_pickup_time" id="morningPickupTime">

<div class="row g-4">

<!-- ================= LEFT ================= -->
<div class="col-md-8">

<h4 class="mb-2">Order for <?= date('D, d M Y', strtotime($orderDate)) ?></h4>

<div class="alert alert-light border small">
<!--Kindly place your order within the daily ordering window, 8:30 AM – 12:30PM. -->
The Canteen Ordering System is undergoing a migration. Please place your orders after 12:30 PM today.
</div>

<?php if (!$can_order): ?>
<div class="alert alert-warning">
Ordering closed. Cutoff <?= sprintf("%02d:%02d", CUTOFF_HOUR, CUTOFF_MIN) ?>.
</div>
<?php endif; ?>

<!-- ===== MORNING MENU ===== -->
<?php if ($morningMenu): ?>
<div class="menu-section">
    <span>☀️ Morning Menu</span>
</div>
<div class="row g-4">
<?php foreach ($morningMenu as $it): ?>
<div class="col-xl-4 col-lg-6 col-md-6">
<div class="card h-100">

<?php if (!empty($it['image'])): ?>
<img src="../uploads/<?= htmlspecialchars($it['image']) ?>" class="menu-img card-img-top">
<?php endif; ?>

<div class="card-body d-flex flex-column">
<h6 class="mb-1"><?= htmlspecialchars($it['title']) ?></h6>
<p class="text-muted small flex-grow-1 lh-sm"><?= nl2br(htmlspecialchars($it['description'])) ?></p>

<div class="d-flex justify-content-between align-items-center">
<span class="price-text">RM <?= number_format($it['price'],2) ?></span>
<div class="input-group input-group-sm" style="width:130px">
<button type="button" class="btn btn-outline-secondary qty-btn btn-minus">−</button>
<input type="number" min="0" value="0"
name="qty[<?= $it['id'] ?>]"
data-id="<?= $it['id'] ?>"
data-title="<?= htmlspecialchars($it['title'], ENT_QUOTES) ?>"
data-price="<?= $it['price'] ?>"
data-session="morning"
class="form-control text-center qty">
<button type="button" class="btn btn-outline-secondary qty-btn btn-plus">+</button>
</div>
</div>
</div>

</div>
</div>
<?php endforeach; ?>
</div>
<?php endif; ?>

<!-- ===== AFTERNOON MENU ===== -->
<?php if ($afternoonMenu): ?>
<div class="menu-section">
    <span>🌙 Afternoon Menu</span>
</div>
<div class="row g-4">
<?php foreach ($afternoonMenu as $it): ?>
<div class="col-xl-4 col-lg-6 col-md-6">
<div class="card h-100">

<?php if (!empty($it['image'])): ?>
<img src="../uploads/<?= htmlspecialchars($it['image']) ?>" class="menu-img card-img-top">
<?php endif; ?>

<div class="card-body d-flex flex-column">
<h6><?= htmlspecialchars($it['title']) ?></h6>
<p class="text-muted small flex-grow-1"><?= nl2br(htmlspecialchars($it['description'])) ?></p>

<div class="d-flex justify-content-between align-items-center">
<span class="price-text">RM <?= number_format($it['price'],2) ?></span>
<div class="input-group input-group-sm" style="width:130px">
<button type="button" class="btn btn-outline-secondary qty-btn btn-minus">−</button>
<input type="number" min="0" value="0"
name="qty[<?= $it['id'] ?>]"
data-id="<?= $it['id'] ?>"
data-title="<?= htmlspecialchars($it['title'], ENT_QUOTES) ?>"
data-price="<?= $it['price'] ?>"
data-session="afternoon"
class="form-control text-center qty">
<button type="button" class="btn btn-outline-secondary qty-btn btn-plus">+</button>
</div>
</div>
</div>

</div>
</div>
<?php endforeach; ?>
</div>
<?php endif; ?>

</div>

<!-- ================= RIGHT (SUMMARY) ================= -->
<div class="col-md-4">
<div class="card summary-card shadow-sm sticky-top" style="top:90px">
<div class="card-body summary-body">

<h6 class="mb-2">🧾 Order Summary</h6>
<p class="small text-muted mb-3">
Review your order before submitting
</p>

<p class="small text-muted">
Order Date<br>
<strong><?= date('D, d M Y', strtotime($orderDate)) ?></strong>
</p>

<div class="summary-scroll small">

<strong>Morning</strong>
<div id="summaryMorning" class="mb-2 text-muted"><em>No items</em></div>

<div id="morningTimeBlock" class="mb-3" style="display:none;">
<div class="small text-muted mb-1">Pickup Time</div>
<div class="btn-group w-100">
<input type="radio" class="btn-check morning-time" value="09:30" id="pt0930">
<label class="btn btn-outline-primary btn-sm" for="pt0930">9:30 AM</label>

<input type="radio" class="btn-check morning-time" value="10:00" id="pt1000">
<label class="btn btn-outline-primary btn-sm" for="pt1000">10:00 AM</label>
</div>

<button type="button"
        class="btn btn-sm btn-outline-secondary mt-2"
        id="resetPickupBtn">
Reset Pickup Time
</button>
</div>

<strong>Afternoon</strong>
<div id="summaryAfternoon" class="text-muted"><em>No items</em></div>

</div>

<div class="d-flex justify-content-between fw-bold fs-5 mt-3 text-primary">
<span>Total</span>
<span>RM <span id="total">0.00</span></span>
</div>

<hr>

<h6>Your Details</h6>
<input name="employee_id" class="form-control form-control-sm mb-2" placeholder="Employee ID" required>
<input name="employee_name" class="form-control form-control-sm mb-2" placeholder="Name" required>
<input type="email" name="employee_email" class="form-control form-control-sm mb-2" placeholder="Email" required>
<input name="employee_phone" class="form-control form-control-sm mb-3" placeholder="Phone (optional)">

<button id="submitBtn"
        class="btn btn-primary w-100"
        <?= !$can_order ? 'disabled' : '' ?>>
    Place Order
</button>
</div>
</div>
</div>

</div>
</form>

<script>
const qtyInputs = document.querySelectorAll('.qty');
const summaryMorning = document.getElementById('summaryMorning');
const summaryAfternoon = document.getElementById('summaryAfternoon');
const totalEl = document.getElementById('total');
const submitBtn = document.getElementById('submitBtn');
const morningBlock = document.getElementById('morningTimeBlock');
const pickupInput = document.getElementById('morningPickupTime');

function changeQty(id, delta) {
    const input = document.querySelector(`input[data-id="${id}"]`);
    if (!input) return;
    input.value = Math.max(0, parseInt(input.value || 0) + delta);
    updateSummary();
}

function updateSummary() {
    let total = 0;
    let hasItem = false;
    let hasMorning = false;
    let mHTML = '';
    let aHTML = '';

    qtyInputs.forEach(i => {
        const qty = parseInt(i.value) || 0;
        if (qty > 0) {
            hasItem = true;
            const sub = qty * i.dataset.price;
            total += sub;
            if (i.dataset.session === 'morning') hasMorning = true;

            const row = `
            <div class="d-flex justify-content-between align-items-center py-1 border-bottom">
              <span>${i.dataset.title}</span>
              <div class="d-flex align-items-center gap-1">
                <button type="button" class="btn btn-sm btn-outline-secondary"
                    onclick="changeQty(${i.dataset.id}, -1)">−</button>
                <span class="fw-semibold">${qty}</span>
                <button type="button" class="btn btn-sm btn-outline-secondary"
                    onclick="changeQty(${i.dataset.id}, 1)">+</button>
                <span class="ms-2">RM ${sub.toFixed(2)}</span>
              </div>
            </div>`;

            (i.dataset.session === 'morning') ? mHTML += row : aHTML += row;
        }
    });

    summaryMorning.innerHTML = mHTML || '<em>No items</em>';
    summaryAfternoon.innerHTML = aHTML || '<em>No items</em>';
    totalEl.textContent = total.toFixed(2);

    if (hasMorning) {
        morningBlock.style.display = 'block';
        const selected = document.querySelector('.morning-time:checked');
        pickupInput.value = selected ? selected.value : '';
        submitBtn.disabled = !hasItem || !selected;
    } else {
        morningBlock.style.display = 'none';
        pickupInput.value = '';
        document.querySelectorAll('.morning-time').forEach(r => r.checked = false);
        submitBtn.disabled = !hasItem;
    }
}

document.getElementById('resetPickupBtn')?.addEventListener('click', () => {
    document.querySelectorAll('.morning-time').forEach(r => r.checked = false);
    pickupInput.value = '';
    submitBtn.disabled = true;
});

document.querySelectorAll('.btn-plus').forEach(b => {
    b.onclick = () => {
        const i = b.closest('.input-group').querySelector('.qty');
        i.value = parseInt(i.value || 0) + 1;
        updateSummary();
    };
});

document.querySelectorAll('.btn-minus').forEach(b => {
    b.onclick = () => {
        const i = b.closest('.input-group').querySelector('.qty');
        i.value = Math.max(0, i.value - 1);
        updateSummary();
    };
});

document.querySelectorAll('.morning-time').forEach(r =>
    r.addEventListener('change', updateSummary)
);

qtyInputs.forEach(i => i.addEventListener('input', updateSummary));

document.getElementById('orderForm').addEventListener('submit', function () {
    submitBtn.disabled = true;
    submitBtn.innerText = 'Submitting...';
});
</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>
