<?php
// includes/functions.php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/../libs/PHPMailer/PHPMailer.php';
require_once __DIR__ . '/../libs/PHPMailer/SMTP.php';
require_once __DIR__ . '/../libs/PHPMailer/Exception.php';

/* ================= ORDER CODE ================= */
function generate_order_code($pdo) {
    $date = date('Ymd');
    $rand = substr(str_shuffle('0123456789'), 0, 5);
    $code = "ORD{$date}{$rand}";

    $stmt = $pdo->prepare("SELECT id FROM orders WHERE order_code = ?");
    $stmt->execute([$code]);

    if ($stmt->fetch()) {
        return generate_order_code($pdo);
    }
    return $code;
}

/* ================= TIME CONTROL ================= */
function is_before_cutoff() {
    $now = new DateTime('now', new DateTimeZone('Asia/Kuala_Lumpur'));
    $cut = (clone $now)->setTime(CUTOFF_HOUR, CUTOFF_MIN, 0);
    return $now < $cut;
}

function is_order_open() {
    $now = new DateTime('now', new DateTimeZone('Asia/Kuala_Lumpur'));
    $open = (clone $now)->setTime(OPEN_HOUR, OPEN_MIN, 0);
    $cutoff = (clone $now)->setTime(CUTOFF_HOUR, CUTOFF_MIN, 0);
    return $now >= $open && $now < $cutoff;
}

function send_email_with_attachment($to, $subject, $html, $attachments = [], $altBody = null) {
    $mail = new PHPMailer(true);
    try {
        // <<< ADD THESE TWO LINES >>>
        $mail->Timeout       = 20;   // Total send timeout (connection + SMTP conversation)
        $mail->SMTPKeepAlive = false;

        // SMTP settings (same as your send_email())
        $mail->isSMTP();
        $mail->Host       = SMTP_HOST;
        $mail->SMTPAuth   = true;
        $mail->Username   = SMTP_USER;
        $mail->Password   = SMTP_PASS;
        $mail->SMTPSecure = SMTP_SECURE;
        $mail->Port       = SMTP_PORT;

        // Encoding & headers
        $mail->CharSet = 'UTF-8';
        $mail->Encoding = 'base64';
        $mail->setFrom(SITE_FROM_EMAIL, SITE_NAME);
        $mail->addAddress($to);
        $mail->addReplyTo(SITE_FROM_EMAIL, SITE_NAME);

        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $html;
        $mail->AltBody = $altBody ?: strip_tags($html);

        // Force unique Message-ID (you already had this, keep it)
        $mail->MessageID = '<' . uniqid('canteen_', true) . '@eastekmy.com>';

        // Attachments
        foreach ($attachments as $file) {
            if (file_exists($file)) {
                $mail->addAttachment($file, basename($file));
            }
        }

        // Optional: uncomment next line only when debugging
        // $mail->SMTPDebug = 2;  // shows full SMTP conversation in browser / log

        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("PHPMailer ERROR to {$to}: " . $mail->ErrorInfo . " | " . $e->getMessage());
        return false;
    }
}

/* ================= EMAIL SENDER ================= */
function send_email($to, $subject, $html) {

    $mail = new PHPMailer(true);

    try {
        /* ---------- SMTP ---------- */
        $mail->isSMTP();
        $mail->Host       = SMTP_HOST;
        $mail->SMTPAuth   = true;
        $mail->Username   = SMTP_USER;
        $mail->Password   = SMTP_PASS;
        $mail->SMTPSecure = SMTP_SECURE;
        $mail->Port       = SMTP_PORT;

        /* ---------- ENCODING ---------- */
        $mail->CharSet  = 'UTF-8';
        $mail->Encoding = 'base64';

        /* ---------- HEADERS ---------- */
        $mail->setFrom(SITE_FROM_EMAIL, SITE_NAME);
        $mail->addAddress($to);
        $mail->addReplyTo(SITE_FROM_EMAIL, SITE_NAME);

        /* ---------- CONTENT ---------- */
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $html;
        $mail->AltBody = strip_tags($html);

        // 🔴 CRITICAL FIX: FORCE UNIQUE MESSAGE-ID
        $mail->MessageID = '<' . uniqid('canteen_', true) . '@eastekmy.com>';

        /* ---------- SEND ---------- */
        $mail->send();
        return true;

    } catch (Exception $e) {
        error_log('PHPMailer Error: ' . $mail->ErrorInfo);
        return false;
    }
}
