<?php
require_once __DIR__ . '/../includes/db.php';

date_default_timezone_set('Asia/Kuala_Lumpur');

$today = new DateTime();
$day = (int)$today->format('N'); // 1=Mon ... 7=Sun

/*
 Next WORKING day logic:
 - Mon(1) → +1 day
 - Tue(2) → +1 day
 - Wed(3) → +1 day
 - Thu(4) → +1 day
 - Fri(5) → +3 days (skip weekend)
 - Sat(6) → +2 days → Monday
 - Sun(7) → +1 day → Monday
*/

if ($day >= 1 && $day <= 4) {
    $foodDate = $today->modify('+1 day');
} elseif ($day === 5) {
    $foodDate = $today->modify('+3 days');
} elseif ($day === 6) {
    $foodDate = $today->modify('+2 days');
} else {
    $foodDate = $today->modify('+1 day');
}

$finalDate = $foodDate->format('Y-m-d');

// Update DB
$stmt = $pdo->prepare("
    UPDATE order_settings
    SET active_order_date = ?
    WHERE id = 1
");
$stmt->execute([$finalDate]);

echo "Food date updated to $finalDate\n";
